# 機能設計書 114-Protocol Bufferエンコード・デコード

## 概要

本ドキュメントは、TensorFlowにおけるProtocol Bufferメッセージのエンコード・デコード操作の設計を記述する。

### 本機能の処理概要

Protocol Buffer形式のバイナリ/テキストデータをテンソルとの間でエンコード・デコードする操作を提供する。構造化データの効率的なシリアライゼーション・デシリアライゼーションを実現する。

**業務上の目的・背景**：TensorFlowのデータパイプラインでは、tf.train.Exampleなどのprotobufメッセージが広く使用されている。TFRecordファイルに保存されたデータの読み込みや、構造化データの前処理において、protobufのエンコード・デコードは必須の操作である。また、任意のprotobufスキーマに対応することで、カスタムデータフォーマットの取り扱いも可能にする。

**機能の利用シーン**：TFRecordファイルからのデータ読み込み時のprotobufデコード、カスタムprotobufスキーマのパース、構造化データのシリアライゼーション、データ前処理パイプラインでのprotobuf変換などで利用される。

**主要な処理内容**：
1. `EncodeProto` - テンソルデータをProtocol Buffer形式にエンコード
2. `DecodeProtoV2` - Protocol Buffer形式のバイナリ/テキストデータをテンソルにデコード

**関連システム・外部連携**：Protocol Bufferスキーマ定義（.proto ファイル）、TFRecordファイル、データ入力パイプライン（tf.data）と連携する。

**権限による制御**：特になし。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | 該当なし | - | 本機能はバックエンドAPI機能であり、直接的な画面関連はない |

## 機能種別

データ変換 / シリアライゼーション

## 入力仕様

### 入力パラメータ

#### EncodeProto

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| sizes | Tensor（int32） | Yes | 各フィールドの反復回数 | - |
| values | list of Tensor | Yes | エンコードするフィールド値 | 各テンソルはランク2以上 |
| field_names | list(string) | Yes | protobufフィールド名リスト | - |
| message_type | string | Yes | protobufメッセージ型名 | - |
| descriptor_source | string | No（デフォルト: 'local://'） | protobufディスクリプタソース | - |

#### DecodeProtoV2

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| bytes | Tensor（string） | Yes | エンコード済みprotobufバイト列 | - |
| message_type | string | Yes | protobufメッセージ型名 | - |
| field_names | list(string) | Yes | デコードするフィールド名リスト | - |
| output_types | list(type) | Yes | 各フィールドの出力型 | >= 0 |
| descriptor_source | string | No（デフォルト: 'local://'） | protobufディスクリプタソース | - |
| message_format | string | No（デフォルト: 'binary'） | メッセージフォーマット | 'binary'または'text' |
| sanitize | bool | No（デフォルト: false） | サニタイズ有効化 | - |

### 入力データソース

Protocol Buffer形式のバイナリデータ（TFRecordファイル等から取得）

## 出力仕様

### 出力データ

#### EncodeProto

| 項目名 | 型 | 説明 |
|--------|-----|------|
| bytes | Tensor（string） | エンコードされたprotobufバイト列 |

#### DecodeProtoV2

| 項目名 | 型 | 説明 |
|--------|-----|------|
| sizes | Tensor（int32） | 各フィールドの反復回数（形状: input_shape + [num_fields]） |
| values | list of Tensor | デコードされたフィールド値（形状: input_shape + [max_repeat]） |

### 出力先

呼び出し元への戻り値として返却

## 処理フロー

### 処理シーケンス

```
1. EncodeProto
   └─ 入力テンソルの形状検証（各フィールドはランク2以上）
   └─ 内側次元を除くバッチ形状をマージ
   └─ protobufスキーマに基づきバイナリエンコード
   └─ バッチ形状のstring Tensorを出力

2. DecodeProtoV2
   └─ 入力バイト列テンソルの形状取得
   └─ sizes出力: input_shape + [num_fields] 形状で各フィールドの反復数
   └─ values出力: input_shape + [unknown_dim] 形状で各フィールド値をデコード
```

### フローチャート

```mermaid
flowchart TD
    A[protobufバイナリ] --> B[DecodeProtoV2]
    B --> C[sizes: フィールド反復数]
    B --> D[values: デコード済みテンソル]
    E[テンソルデータ] --> F[EncodeProto]
    F --> G[protobufバイナリ]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-114-01 | フィールド形状制約 | EncodeProtoの各フィールドテンソルはランク2以上 | EncodeProto使用時 |
| BR-114-02 | バッチ形状整合 | EncodeProtoの全フィールドのバッチ形状が一致すること | EncodeProto使用時 |
| BR-114-03 | ディスクリプタソース | デフォルトは'local://'（ローカルコンパイル済みディスクリプタ） | 両操作 |
| BR-114-04 | バイナリ/テキスト形式 | DecodeProtoV2はbinary形式とtext形式の両方に対応 | DecodeProtoV2使用時 |

### 計算ロジック

Protocol Buffer仕様に基づくバイナリエンコード/デコード。

## データベース操作仕様

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| InvalidArgument | 形状不正 | フィールドテンソルのランクが2未満 | ランク2以上のテンソルを使用 |
| InvalidArgument | バッチ形状不一致 | フィールド間でバッチ形状が異なる | 全フィールドのバッチ形状を統一 |
| InvalidArgument | ディスクリプタ未発見 | 指定されたmessage_typeが解決できない | 正しいmessage_typeとdescriptor_sourceを指定 |

### リトライ仕様

該当なし

## トランザクション仕様

該当なし

## パフォーマンス要件

エンコード・デコードはバッチ単位で並列実行可能。計算量はメッセージサイズとフィールド数に比例。

## セキュリティ考慮事項

sanitizeオプションにより、不正なprotobufデータの安全な処理が可能。信頼できないソースからのprotobufデータを処理する場合はsanitize=trueの使用を推奨。

## 備考

- DecodeProtoV2のshape推論において、optionalフィールドやrequiredフィールドの反復次元を1に設定する最適化は未実装（TODOコメントあり）。
- repeatedフィールドの最大数を制限する入力引数の追加も検討中。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エンコード操作を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | encode_proto_ops.cc | `tensorflow/core/ops/encode_proto_ops.cc` | EncodeProto Opの入出力定義とshape推論 |

**主要処理フロー**:
1. **24-47行目**: EncodeProto Op登録 - sizes(int32)とvalues(Tinput_types)を入力とし、bytes(string)を出力
2. **32-46行目**: Shape推論 - 各フィールドテンソルのバッチ形状（先頭次元を除く）をマージし、出力形状を決定

**読解のコツ**: `c->Subshape(input, 0, -1, &inner)` は入力テンソルの最後の次元を除くサブ形状を取得する。これにより各フィールドのバッチ次元を統一的に扱う。

#### Step 2: デコード操作を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | decode_proto_ops.cc | `tensorflow/core/ops/decode_proto_ops.cc` | DecodeProtoV2 Opの入出力定義とshape推論 |

**主要処理フロー**:
1. **24-59行目**: DecodeProtoV2 Op登録 - bytes(string)を入力とし、sizes(int32)とvalues(output_types)を出力
2. **40-43行目**: sizes出力のshape推論 - input_shape + [num_output_types]
3. **51-56行目**: values出力のshape推論 - input_shape + [UnknownDim]（反復数が動的のため）

### プログラム呼び出し階層図

```
Python API (tf.io.encode_proto / tf.io.decode_proto)
    │
    ├─ EncodeProto Op
    │      ├─ Input: sizes(int32), values(Tinput_types)
    │      ├─ Attr: field_names, message_type, descriptor_source
    │      └─ Output: bytes(string)
    │
    └─ DecodeProtoV2 Op
           ├─ Input: bytes(string)
           ├─ Attr: message_type, field_names, output_types, message_format, sanitize
           └─ Output: sizes(int32), values(output_types)
```

### データフロー図

```
[入力]                     [処理]                        [出力]

Tensor値 + sizes ───▶ EncodeProto ──────────────▶ protobuf bytes
field_names      ───▶

protobuf bytes ─────▶ DecodeProtoV2 ─────────── ▶ sizes + values
field_names     ────▶                               (テンソル群)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| encode_proto_ops.cc | `tensorflow/core/ops/encode_proto_ops.cc` | ソース | EncodeProto Op定義 |
| decode_proto_ops.cc | `tensorflow/core/ops/decode_proto_ops.cc` | ソース | DecodeProtoV2 Op定義 |
| op.h | `tensorflow/core/framework/op.h` | ヘッダー | REGISTER_OPマクロ定義 |
| shape_inference.h | `tensorflow/core/framework/shape_inference.h` | ヘッダー | 形状推論フレームワーク |
